
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")

# Objective function: Minimize 5*x0 + 2*x1
m.setObjective(5*x0 + 2*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 7*x1 >= 31, "healthiness_min")
m.addConstr(5*x0 + 7*x1 <= 52, "healthiness_max")
m.addConstr(2*x0 + x1 >= 20, "tastiness_min")
m.addConstr(2*x0 + x1 <= 50, "tastiness_max")
m.addConstr(8*x0 + 10*x1 >= 24, "fiber_min")
m.addConstr(8*x0 + 10*x1 <= 30, "fiber_max")
m.addConstr(9*x0 - x1 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Potatoes: {x0.x}")
    print(f"Protein Bars: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
