
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    potatoes = model.addVar(lb=0, name="potatoes", vtype=gurobi.GRB.CONTINUOUS)
    protein_bars = model.addVar(lb=0, name="protein_bars", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize 5 * potatoes + 2 * protein_bars
    model.setObjective(5 * potatoes + 2 * protein_bars, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstraint(5 * potatoes + 7 * protein_bars >= 31, name="healthiness_rating_min")
    model.addConstraint(5 * potatoes + 7 * protein_bars <= 71, name="healthiness_rating_max")
    model.addConstraint(2 * potatoes + protein_bars >= 20, name="tastiness_rating_min")
    model.addConstraint(2 * potatoes + protein_bars <= 52, name="tastiness_rating_max")
    model.addConstraint(8 * potatoes + 10 * protein_bars >= 24, name="fiber_min")
    model.addConstraint(8 * potatoes + 10 * protein_bars <= 54, name="fiber_max")
    model.addConstraint(9 * potatoes - protein_bars >= 0, name="additional_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Potatoes: {potatoes.varValue}")
        print(f"Protein Bars: {protein_bars.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
