
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
z = m.addVar(lb=-gp.GRB.INFINITY, name="z")  # milligrams of zinc
k = m.addVar(lb=-gp.GRB.INFINITY, name="k")  # milligrams of vitamin K
b = m.addVar(lb=-gp.GRB.INFINITY, name="b")  # milligrams of vitamin B3
a = m.addVar(lb=-gp.GRB.INFINITY, name="a")  # milligrams of vitamin A
f = m.addVar(lb=-gp.GRB.INFINITY, name="f")  # grams of fiber

# Objective function
m.setObjective(4 * z + k + 2 * b + a + 2 * f, gp.GRB.MINIMIZE)

# Digestive support index constraints
m.addConstr(14 * z <= 213)
m.addConstr(4 * k <= 213)
m.addConstr(15 * b <= 213)
m.addConstr(2 * a <= 213)
m.addConstr(5 * f <= 213)
m.addConstr(4 * k + 15 * b >= 24)
m.addConstr(14 * z + 4 * k >= 34)
m.addConstr(14 * z + 2 * a >= 22)
m.addConstr(4 * k + 5 * f >= 41)
m.addConstr(2 * a + 5 * f >= 23)
m.addConstr(15 * b + 5 * f >= 31)
m.addConstr(14 * z + 15 * b >= 41)
m.addConstr(14 * z + 15 * b + 2 * a >= 36)
m.addConstr(15 * b + 2 * a + 5 * f >= 36)
m.addConstr(4 * k + 2 * a + 5 * f >= 36)
m.addConstr(4 * k + 15 * b + 2 * a >= 36)

# Immune support index constraints
m.addConstr(15 * z + 18 * k >= 20)
m.addConstr(13 * b + 4 * a >= 22)
m.addConstr(15 * z + 13 * b >= 18)
m.addConstr(15 * z + 10 * f >= 13)
m.addConstr(18 * k + 4 * a >= 15)
m.addConstr(15 * z + 4 * a >= 20)
m.addConstr(15 * z + 18 * k + 4 * a >= 17)

# Muscle growth index constraints
m.addConstr(13 * z + 19 * a >= 42)
m.addConstr(9 * b + 19 * a >= 16)
m.addConstr(6 * k + 15 * f >= 26)
m.addConstr(13 * z + 6 * k + 9 * b + 19 * a + 15 * f >= 26)
m.addConstr(-4 * b + 7 * a >= 0)

# Other constraints
m.addConstr(9 * b + 2 * a <= 93)
m.addConstr(4 * k + 15 * b <= 192)
m.addConstr(4 * k + 2 * a <= 128)
m.addConstr(14 * z + 5 * f <= 57)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("z: ", z.varValue)
    print("k: ", k.varValue)
    print("b: ", b.varValue)
    print("a: ", a.varValue)
    print("f: ", f.varValue)
else:
    print("The model is infeasible.")
