
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
eggs = m.addVar(vtype=GRB.CONTINUOUS, name="eggs")
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")

# Set objective function
m.setObjective(3*cherry_pies**2 + 6*cherry_pies*eggs + 4*cherry_pies*green_beans + eggs**2 + 3*eggs*green_beans + 9*green_beans**2 + 5*cherry_pies + eggs + 8*green_beans, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*cherry_pies + 6*eggs >= 21, "c0")
m.addConstr(5*cherry_pies + 6*eggs + 3*green_beans >= 20, "c1")
m.addConstr(7*eggs + 2*green_beans >= 24, "c2")
m.addConstr(2*cherry_pies + 7*eggs >= 46, "c3")
m.addConstr(2*cherry_pies + 7*eggs + 2*green_beans >= 46, "c4")
m.addConstr(4*cherry_pies**2 + 7*green_beans**2 >= 26, "c5")
m.addConstr(4*cherry_pies + 8*eggs >= 43, "c6")
m.addConstr(4*cherry_pies + 8*eggs + 7*green_beans >= 43, "c7")
m.addConstr(5*cherry_pies + 3*green_beans >= 14, "c8")
m.addConstr(5*cherry_pies + eggs >= 12, "c9")
m.addConstr(5*cherry_pies + eggs + 3*green_beans >= 8, "c10")
m.addConstr(4*cherry_pies + 4*green_beans >= 22, "c11")
m.addConstr(4*cherry_pies + 10*eggs >= 33, "c12")
m.addConstr(4*cherry_pies + 10*eggs + 4*green_beans >= 33, "c13")
m.addConstr(10*cherry_pies**2 - eggs**2 >= 0, "c14")
m.addConstr(-eggs + 8*green_beans >= 0, "c15")

m.addConstr(5*cherry_pies + 6*eggs + 3*green_beans <= 41, "c16") # new upper bound constraint
m.addConstr(2*cherry_pies + 7*eggs <= 61, "c17") # new upper bound constraint
m.addConstr(8*eggs + 7*green_beans <= 111, "c18") # new upper bound constraint
m.addConstr(4*cherry_pies + 7*green_beans <= 94, "c19") # new upper bound constraint
m.addConstr(4*cherry_pies + 8*eggs <= 49, "c20") # new upper bound constraint
m.addConstr(eggs**2 + 3*green_beans**2 <= 30, "c21") # new upper bound constraint
m.addConstr(4*cherry_pies + 10*eggs <= 76, "c22") # new upper bound constraint
m.addConstr(4*cherry_pies + 10*eggs + 4*green_beans <= 97, "c23") # new upper bound constraint


# Resource Constraints
m.addConstr(5*cherry_pies + 6*eggs + 3*green_beans <= 67, "umami")
m.addConstr(2*cherry_pies + 7*eggs + 2*green_beans <= 144, "healthiness")
m.addConstr(4*cherry_pies + 8*eggs + 7*green_beans <= 143, "protein")
m.addConstr(5*cherry_pies + eggs + 3*green_beans <= 42, "tastiness")
m.addConstr(4*cherry_pies + 10*eggs + 4*green_beans <= 162, "fiber")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cherry_pies:', cherry_pies.x)
    print('eggs:', eggs.x)
    print('green_beans:', green_beans.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
