
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
cherry_pies = m.addVar(vtype=gp.GRB.INTEGER, name="cherry_pies")
eggs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="eggs")
green_beans = m.addVar(vtype=gp.GRB.INTEGER, name="green_beans")

# Define the objective function
m.setObjective(3 * cherry_pies ** 2 + 6 * cherry_pies * eggs + 4 * cherry_pies * green_beans + 
               eggs ** 2 + 3 * eggs * green_beans + 9 * green_beans ** 2 + 
               5 * cherry_pies + eggs + 8 * green_beans, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * cherry_pies >= 5, name="umami_cherry_pies")
m.addConstr(2 * cherry_pies >= 2, name="healthiness_cherry_pies")
m.addConstr(4 * cherry_pies >= 4, name="protein_cherry_pies")
m.addConstr(5 * cherry_pies >= 5, name="tastiness_cherry_pies")
m.addConstr(4 * cherry_pies >= 4, name="fiber_cherry_pies")

m.addConstr(6 * eggs >= 6, name="umami_eggs")
m.addConstr(7 * eggs >= 7, name="healthiness_eggs")
m.addConstr(8 * eggs >= 8, name="protein_eggs")
m.addConstr(eggs >= 1, name="tastiness_eggs")
m.addConstr(10 * eggs >= 10, name="fiber_eggs")

m.addConstr(3 * green_beans >= 3, name="umami_green_beans")
m.addConstr(2 * green_beans >= 2, name="healthiness_green_beans")
m.addConstr(7 * green_beans >= 7, name="protein_green_beans")
m.addConstr(3 * green_beans >= 3, name="tastiness_green_beans")
m.addConstr(4 * green_beans >= 4, name="fiber_green_beans")

m.addConstr(5 * cherry_pies + 6 * eggs >= 21, name="umami_total_1")
m.addConstr(5 * cherry_pies + 6 * eggs + 3 * green_beans >= 20, name="umami_total_2")

m.addConstr(7 * eggs + 2 * green_beans >= 24, name="healthiness_eggs_green_beans")
m.addConstr(2 * cherry_pies + 7 * eggs >= 46, name="healthiness_cherry_pies_eggs")
m.addConstr(2 * cherry_pies + 7 * eggs + 2 * green_beans >= 46, name="healthiness_total")

m.addConstr((4 * cherry_pies) ** 2 + (7 * green_beans) ** 2 >= 26, name="protein_total_1")
m.addConstr(4 * cherry_pies + 8 * eggs >= 43, name="protein_total_2")
m.addConstr(4 * cherry_pies + 8 * eggs + 7 * green_beans >= 43, name="protein_total_3")

m.addConstr(5 * cherry_pies + 3 * green_beans >= 14, name="tastiness_cherry_pies_green_beans")
m.addConstr(5 * cherry_pies + eggs >= 12, name="tastiness_cherry_pies_eggs")
m.addConstr(5 * cherry_pies + eggs + 3 * green_beans >= 8, name="tastiness_total")

m.addConstr(4 * cherry_pies + 4 * green_beans >= 22, name="fiber_cherry_pies_green_beans")
m.addConstr(4 * cherry_pies + 10 * eggs >= 33, name="fiber_cherry_pies_eggs")
m.addConstr(4 * cherry_pies + 10 * eggs + 4 * green_beans >= 33, name="fiber_total")

m.addConstr(10 * cherry_pies ** 2 - eggs ** 2 >= 0, name="constraint_1")
m.addConstr(-eggs + 8 * green_beans >= 0, name="constraint_2")

m.addConstr(5 * cherry_pies + 6 * eggs + 3 * green_beans <= 41, name="umami_total_max")
m.addConstr(2 * cherry_pies + 7 * eggs <= 61, name="healthiness_max")

m.addConstr(8 * eggs + 7 * green_beans <= 111, name="protein_eggs_green_beans_max")
m.addConstr(4 * cherry_pies + 7 * green_beans <= 94, name="protein_cherry_pies_green_beans_max")
m.addConstr(4 * cherry_pies + 8 * eggs <= 49, name="protein_cherry_pies_eggs_max")

m.addConstr(eggs ** 2 + 3 * green_beans ** 2 <= 30, name="tastiness_max")

m.addConstr(4 * cherry_pies + 10 * eggs <= 76, name="fiber_cherry_pies_eggs_max")
m.addConstr(4 * cherry_pies + 10 * eggs + 4 * green_beans <= 97, name="fiber_total_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cherry Pies: ", cherry_pies.varValue)
    print("Eggs: ", eggs.varValue)
    print("Green Beans: ", green_beans.varValue)
else:
    print("The model is infeasible")
