
from gurobipy import *

try:
    # Create a new model
    m = Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Dale")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours worked by George")

    # Set objective function
    m.setObjective(7 * x0 + 4 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7.09 * x0 + 5.38 * x1 >= 49, "c0")  # paperwork competence rating (>= 49)
    m.addConstr(4.11 * x0 + 6.11 * x1 >= 45, "c1")  # dollar cost per hour (>= 45)
    m.addConstr(2.68 * x0 + 4.9 * x1 >= 95, "c2")   # work quality rating (>= 95)
    m.addConstr(0.85 * x0 + 3.05 * x1 >= 63, "c3")   # likelihood to quit index (>= 63)
    m.addConstr(-10 * x0 + 3 * x1 >= 0, "c4")       # -10x0 + 3x1 >= 0
    m.addConstr(7.09 * x0 + 5.38 * x1 <= 119, "c5") # paperwork competence rating (<= 119)
    m.addConstr(4.11 * x0 + 6.11 * x1 <= 109, "c6") # dollar cost per hour (<= 109)
    m.addConstr(2.68 * x0 + 4.9 * x1 <= 169, "c7")  # work quality rating (<= 169)
    m.addConstr(0.85 * x0 + 3.05 * x1 <= 109, "c8")  # likelihood to quit index (<= 109)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
