
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")

# Objective function: minimize 7*x0 + 4*x1
m.setObjective(7*x0 + 4*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(7.09*x0 + 5.38*x1 >= 49, name="paperwork_competence_rating_min")
m.addConstr(4.11*x0 + 6.11*x1 >= 45, name="dollar_cost_per_hour_min")
m.addConstr(2.68*x0 + 4.9*x1 >= 95, name="work_quality_rating_min")
m.addConstr(0.85*x0 + 3.05*x1 >= 63, name="likelihood_to_quit_index_min")
m.addConstr(-10*x0 + 3*x1 >= 0, name="additional_linear_constraint")
m.addConstr(7.09*x0 + 5.38*x1 <= 119, name="paperwork_competence_rating_max")
m.addConstr(4.11*x0 + 6.11*x1 <= 109, name="dollar_cost_per_hour_max")
m.addConstr(2.68*x0 + 4.9*x1 <= 169, name="work_quality_rating_max")
m.addConstr(0.85*x0 + 3.05*x1 <= 109, name="likelihood_to_quit_index_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Dale:", x0.x)
    print("Hours worked by George:", x1.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
