
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", lb=0)  # Can be fractional
x1 = m.addVar(name="hours_worked_by_George", lb=0, integrality=gp.GRB.INTEGER)  # Must be an integer

# Define the objective function
m.setObjective(7 * x0 + 4 * x1, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7.09 * x0 + 5.38 * x1 >= 49, name="paperwork_competence_rating")
m.addConstr(4.11 * x0 + 6.11 * x1 >= 45, name="dollar_cost_per_hour")
m.addConstr(2.68 * x0 + 4.9 * x1 >= 95, name="work_quality_rating")
m.addConstr(0.85 * x0 + 3.05 * x1 >= 63, name="likelihood_to_quit_index")
m.addConstr(-10 * x0 + 3 * x1 >= 0, name="mixed_constraint")
m.addConstr(7.09 * x0 + 5.38 * x1 <= 119, name="paperwork_competence_rating_upper")
m.addConstr(4.11 * x0 + 6.11 * x1 <= 109, name="dollar_cost_per_hour_upper")
m.addConstr(2.68 * x0 + 4.9 * x1 <= 169, name="work_quality_rating_upper")
m.addConstr(0.85 * x0 + 3.05 * x1 <= 109, name="likelihood_to_quit_index_upper")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Dale: {x0.varValue}")
    print(f"Hours worked by George: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
