
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bill_hours = m.addVar(lb=0, name="bill_hours")
bobby_hours = m.addVar(lb=0, name="bobby_hours")
paul_hours = m.addVar(lb=0, name="paul_hours")

# Set objective function
m.setObjective(3 * bill_hours + 3 * bobby_hours + 1 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * bill_hours + 12 * paul_hours >= 11, "work_quality_bill_paul")
m.addConstr(11 * bobby_hours + 12 * paul_hours >= 11, "work_quality_bobby_paul")
m.addConstr(2 * bill_hours + 11 * bobby_hours + 12 * paul_hours >= 11, "work_quality_all")
m.addConstr(10 * bobby_hours + 10 * paul_hours >= 24, "computer_competence_bobby_paul")
m.addConstr(12 * bill_hours + 10 * bobby_hours >= 37, "computer_competence_bill_bobby")
m.addConstr(12 * bill_hours + 10 * paul_hours >= 22, "computer_competence_bill_paul")
m.addConstr(12 * bill_hours + 10 * bobby_hours + 10 * paul_hours >= 37, "computer_competence_all")
m.addConstr(1 * bill_hours - 10 * bobby_hours >= 0, "bill_bobby_relation")
m.addConstr(2 * bill_hours + 11 * bobby_hours <= 51, "work_quality_bill_bobby_max")
m.addConstr(2 * bill_hours + 11 * bobby_hours + 12 * paul_hours <= 29, "work_quality_all_max")
m.addConstr(12 * bill_hours + 10 * paul_hours <= 53, "computer_competence_bill_paul_max")
m.addConstr(12 * bill_hours + 10 * bobby_hours + 10 * paul_hours <= 141, "computer_competence_all_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Bill hours:', bill_hours.x)
    print('Bobby hours:', bobby_hours.x)
    print('Paul hours:', paul_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

