
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Decision Variables
x0 = m.addVar(lb=0, name='hours_worked_by_Bill')  # Hours worked by Bill
x1 = m.addVar(lb=0, name='hours_worked_by_Bobby')  # Hours worked by Bobby
x2 = m.addVar(lb=0, name='hours_worked_by_Paul')   # Hours worked by Paul

# Objective Function: Minimize 3*x0 + 3*x1 + x2
m.setObjective(3*x0 + 3*x1 + x2, GRB.MINIMIZE)

# Constraints
# Work quality and computer competence ratings are not directly used as constraints but influence the combined ratings
# Combined work quality ratings
m.addConstr(2*x0 + 12*x2 >= 11, name='work_quality_Bill_Paul')
m.addConstr(11*x1 + 12*x2 >= 11, name='work_quality_Bobby_Paul')
m.addConstr(2*x0 + 11*x1 + 12*x2 >= 11, name='total_work_quality')
# Combined computer competence ratings
m.addConstr(10*x1 + 10*x2 >= 24, name='computer_competence_Bobby_Paul')
m.addConstr(12*x0 + 10*x1 >= 37, name='computer_competence_Bill_Bobby')
m.addConstr(12*x0 + 10*x2 >= 22, name='computer_competence_Bill_Paul')
m.addConstr(12*x0 + 10*x1 + 10*x2 >= 37, name='total_computer_competence_min')
# Additional constraints
m.addConstr(x0 - 10*x1 >= 0, name='Bill_vs_Bobby_hours')
m.addConstr(2*x0 + 11*x1 <= 51, name='work_quality_Bill_Bobby_max')
m.addConstr(2*x0 + 11*x1 + 12*x2 <= 29, name='total_work_quality_max')
m.addConstr(12*x0 + 10*x2 <= 53, name='computer_competence_Bill_Paul_max')
m.addConstr(12*x0 + 10*x1 + 10*x2 <= 141, name='total_computer_competence_max')

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bill: {x0.x}")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
else:
    print("No optimal solution found")
