
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
bill_hours = model.addVar(name="bill_hours", lb=0)  # hours worked by Bill
bobby_hours = model.addVar(name="bobby_hours", lb=0)  # hours worked by Bobby
paul_hours = model.addVar(name="paul_hours", lb=0)  # hours worked by Paul

# Objective function: minimize 3*Bill + 3*Bobby + 1*Paul
model.setObjective(3 * bill_hours + 3 * bobby_hours + 1 * paul_hours, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstraint(2 * bill_hours <= 74, name="bill_work_quality")
model.addConstraint(12 * bill_hours <= 145, name="bill_computer_competence")

model.addConstraint(11 * bobby_hours <= 74, name="bobby_work_quality")
model.addConstraint(10 * bobby_hours <= 145, name="bobby_computer_competence")

model.addConstraint(12 * paul_hours <= 74, name="paul_work_quality")
model.addConstraint(10 * paul_hours <= 145, name="paul_computer_competence")

model.addConstraint(2 * bill_hours + 12 * paul_hours >= 11, name="bill_paul_work_quality")
model.addConstraint(11 * bobby_hours + 12 * paul_hours >= 11, name="bobby_paul_work_quality")
model.addConstraint(2 * bill_hours + 11 * bobby_hours + 12 * paul_hours >= 11, name="total_work_quality")

model.addConstraint(10 * bobby_hours + 10 * paul_hours >= 24, name="bobby_paul_computer_competence")
model.addConstraint(12 * bill_hours + 10 * bobby_hours >= 37, name="bill_bobby_computer_competence")
model.addConstraint(12 * bill_hours + 10 * paul_hours >= 22, name="bill_paul_computer_competence")
model.addConstraint(12 * bill_hours + 10 * bobby_hours + 10 * paul_hours >= 37, name="total_computer_competence")

model.addConstraint(bill_hours - 10 * bobby_hours >= 0, name="bill_bobby_hours")

model.addConstraint(2 * bill_hours + 11 * bobby_hours <= 51, name="bill_bobby_work_quality_max")
model.addConstraint(2 * bill_hours + 11 * bobby_hours + 12 * paul_hours <= 29, name="total_work_quality_max")

model.addConstraint(12 * bill_hours + 10 * paul_hours <= 53, name="bill_paul_computer_competence_max")
model.addConstraint(12 * bill_hours + 10 * bobby_hours + 10 * paul_hours <= 141, name="total_computer_competence_max")

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bill: {bill_hours.varValue}")
    print(f"Hours worked by Bobby: {bobby_hours.varValue}")
    print(f"Hours worked by Paul: {paul_hours.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
