
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Food Cost")

# Create variables
kale_salads = model.addVar(vtype=GRB.CONTINUOUS, name="kale_salads")
chicken_thighs = model.addVar(vtype=GRB.CONTINUOUS, name="chicken_thighs")

# Set objective function
model.setObjective(2 * kale_salads + 9 * chicken_thighs, GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * kale_salads + 14 * chicken_thighs >= 45, "protein_minimum")
model.addConstr(7 * kale_salads + 1 * chicken_thighs >= 22, "healthiness_minimum")
model.addConstr(-10 * kale_salads + 7 * chicken_thighs >= 0, "custom_constraint")
model.addConstr(2 * kale_salads + 14 * chicken_thighs <= 94, "protein_maximum")  # Added protein upper bound
model.addConstr(7 * kale_salads + 1 * chicken_thighs <= 55, "healthiness_maximum") # Added healthiness upper bound


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal objective value:", model.objVal)
    print("Kale salads:", kale_salads.x)
    print("Chicken thighs:", chicken_thighs.x)

