
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")

# Set the objective function
m.setObjective(2*x0 + 9*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x0 + 14*x1 >= 45, "protein_min")
m.addConstr(2*x0 + 14*x1 <= 94, "protein_max")
m.addConstr(7*x0 + x1 >= 22, "healthiness_min")
m.addConstr(7*x0 + x1 <= 55, "healthiness_max")
m.addConstr(-10*x0 + 7*x1 >= 0, "other_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"kale_salads: {x0.x}")
    print(f"chicken_thighs: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
