
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    kale_salads = model.addVar(name="kale_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    chicken_thighs = model.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function: Minimize 2 * kale_salads + 9 * chicken_thighs
    model.setObjective(2 * kale_salads + 9 * chicken_thighs, gurobi.GRB.MINIMIZE)

    # Constraints
    # Protein content at least 45
    model.addConstr(2 * kale_salads + 14 * chicken_thighs >= 45, name="protein_content")

    # Healthiness rating at least 22
    model.addConstr(7 * kale_salads + chicken_thighs >= 22, name="healthiness_rating")

    # Linear constraint: -10 * kale_salads + 7 * chicken_thighs >= 0
    model.addConstr(-10 * kale_salads + 7 * chicken_thighs >= 0, name="linear_constraint")

    # Protein content at most 98
    model.addConstr(2 * kale_salads + 14 * chicken_thighs <= 98, name="protein_bound")

    # Healthiness rating at most 90
    model.addConstr(7 * kale_salads + chicken_thighs <= 90, name="healthiness_bound")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Kale Salads: {kale_salads.varValue}")
        print(f"Chicken Thighs: {chicken_thighs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimization_problem()
