
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
iron = m.addVar(lb=0, name="iron")
b9 = m.addVar(lb=0, name="b9")
b12 = m.addVar(lb=0, name="b12")

# Set objective function
m.setObjective(1.1 * iron**2 + 4.45 * b9**2 + 7.36 * b12**2 + 3.64 * iron + 2.76 * b12, gp.GRB.MAXIMIZE)

# Add constraints based on resource attributes
resource_data = {
    'r0': {'description': 'energy stability index', 'upper_bound': 218, 'x0': 13, 'x1': 4, 'x2': 16},
    'r1': {'description': 'cognitive performance index', 'upper_bound': 177, 'x0': 1, 'x1': 12, 'x2': 21},
    'r2': {'description': 'muscle growth index', 'upper_bound': 289, 'x0': 23, 'x1': 10, 'x2': 14}
}

for resource, data in resource_data.items():
    m.addConstr(data['x0'] * iron + data['x1'] * b9 + data['x2'] * b12 <= data['upper_bound'], resource)

# Add additional constraints
m.addConstr(4 * b9 + 16 * b12 >= 26, "c1")
m.addConstr(13 * iron + 16 * b12 >= 24, "c2")
m.addConstr(1 * iron + 21 * b12 >= 43, "c3")
m.addConstr(12 * b9**2 + 21 * b12**2 >= 35, "c4")  # Note: Non-linear constraint
m.addConstr(10 * b9 + 14 * b12 >= 78, "c5")
m.addConstr(23 * iron + 14 * b12 >= 37, "c6")
m.addConstr(13 * iron + 4 * b9 <= 126, "c7")
m.addConstr(13 * iron + 16 * b12 <= 110, "c8")
m.addConstr(13 * iron + 4 * b9 + 16 * b12 <= 110, "c9")
m.addConstr(12 * b9 + 21 * b12 <= 157, "c10")
m.addConstr(1 * iron + 12 * b9 <= 157, "c11")
m.addConstr(1 * iron + 12 * b9 + 21 * b12 <= 157, "c12")
m.addConstr(10 * b9**2 + 14 * b12**2 <= 231, "c13") # Note: Non-linear constraint
m.addConstr(23 * iron**2 + 14 * b12**2 <= 105, "c14") # Note: Non-linear constraint
m.addConstr(23 * iron + 10 * b9 + 14 * b12 <= 105, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('iron:', iron.x)
    print('b9:', b9.x)
    print('b12:', b12.x)
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

