
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="milligrams_of_iron", lb=0)  # Assuming non-negative for practical purposes
x1 = m.addVar(name="milligrams_of_vitamin_B9", lb=0)  # Assuming non-negative for practical purposes
x2 = m.addVar(name="milligrams_of_vitamin_B12", lb=0)  # Assuming non-negative for practical purposes

# Objective function
m.setObjective(1.1*x0**2 + 4.45*x1**2 + 7.36*x2**2 + 3.64*x0 + 2.76*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(13*x0 <= 218)
m.addConstr(x0 <= 177)
m.addConstr(23*x0 <= 289)

m.addConstr(4*x1 <= 218)
m.addConstr(12*x1 <= 177)
m.addConstr(10*x1 <= 289)

m.addConstr(16*x2 <= 218)
m.addConstr(21*x2 <= 177)
m.addConstr(14*x2 <= 289)

m.addConstr(4*x1 + 16*x2 >= 26)
m.addConstr(13*x0 + 16*x2 >= 24)
m.addConstr(x0 + 21*x2 >= 43)
m.addConstr(12**2*x1**2 + 21**2*x2**2 >= 35)
m.addConstr(10*x1 + 14*x2 >= 78)
m.addConstr(23*x0 + 14*x2 >= 37)

m.addConstr(13*x0 + 4*x1 <= 126)
m.addConstr(13*x0 + 16*x2 <= 110)
m.addConstr(13*x0 + 4*x1 + 16*x2 <= 110)

m.addConstr(12*x1 + 21*x2 <= 157)
m.addConstr(x0 + 12*x1 <= 157)
m.addConstr(x0 + 12*x1 + 21*x2 <= 157)

m.addConstr(10**2*x1**2 + 14**2*x2**2 <= 231)
m.addConstr(23**2*x0**2 + 14**2*x2**2 <= 105)
m.addConstr(23*x0 + 10*x1 + 14*x2 <= 105)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal Solution:")
    print(f"Milligrams of iron: {x0.varValue}")
    print(f"Milligrams of vitamin B9: {x1.varValue}")
    print(f"Milligrams of vitamin B12: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
