
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_potassium", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="grams_of_fiber", lb=0, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)
x2 = m.addVar(name="milligrams_of_vitamin_D", lb=0, ub=gp.GRB.INFINITY, integrality=gp.GRB.INTEGER)
x3 = m.addVar(name="milligrams_of_vitamin_B12", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(3.17*x0 + 2.34*x1 + 2.79*x2 + 1.75*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x0 <= 478)
m.addConstr(4*x0 <= 417)
m.addConstr(16*x0 <= 255)
m.addConstr(1*x1 <= 478)
m.addConstr(6*x1 <= 417)
m.addConstr(7*x1 <= 255)
m.addConstr(15*x2 <= 478)
m.addConstr(10*x2 <= 417)
m.addConstr(2*x2 <= 255)
m.addConstr(17*x3 <= 478)
m.addConstr(1*x3 <= 417)
m.addConstr(3*x3 <= 255)
m.addConstr(9*x0 + 1*x1 >= 61)
m.addConstr(1*x1 + 15*x2 >= 98)
m.addConstr(15*x2 + 17*x3 >= 101)
m.addConstr(9*x0 + 15*x2 >= 112)
m.addConstr(9*x0 + 1*x1 + 15*x2 >= 81)
m.addConstr(1*x1 + 15*x2 + 17*x3 >= 81)
m.addConstr(9*x0 + 1*x1 + 17*x3 >= 81)
m.addConstr(9*x0 + 1*x1 + 15*x2 >= 85)
m.addConstr(1*x1 + 15*x2 + 17*x3 >= 85)
m.addConstr(9*x0 + 1*x1 + 17*x3 >= 85)
m.addConstr(9*x0 + 1*x1 + 15*x2 >= 61)
m.addConstr(1*x1 + 15*x2 + 17*x3 >= 61)
m.addConstr(9*x0 + 1*x1 + 17*x3 >= 61)
m.addConstr(9*x0 + 1*x1 + 15*x2 + 17*x3 >= 61)
m.addConstr(4*x0 + 6*x1 + 10*x2 + 1*x3 >= 61)
m.addConstr(2*x2 + 3*x3 >= 44)
m.addConstr(16*x0 + 2*x2 >= 35)
m.addConstr(7*x1 + 2*x2 + 3*x3 >= 40)
m.addConstr(16*x0 + 7*x1 + 2*x2 + 3*x3 >= 40)
m.addConstr(2*x0 - 5*x3 >= 0)
m.addConstr(-5*x0 + 5*x2 >= 0)
m.addConstr(-5*x0 + 5*x1 >= 0)
m.addConstr(4*x0 + 6*x1 <= 244)
m.addConstr(4*x0 + 1*x3 <= 383)
m.addConstr(6*x1 + 1*x3 <= 373)
m.addConstr(4*x0 + 10*x2 + 1*x3 <= 113)
m.addConstr(4*x0 + 6*x1 + 1*x3 <= 142)
m.addConstr(7*x1 + 3*x3 <= 220)
m.addConstr(16*x0 + 3*x3 <= 124)
m.addConstr(16*x0 + 7*x1 + 2*x2 <= 229)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of potassium: {x0.varValue}")
    print(f"Grams of fiber: {x1.varValue}")
    print(f"Milligrams of vitamin D: {x2.varValue}")
    print(f"Milligrams of vitamin B12: {x3.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
