
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
hot_dogs = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")
blueberry_pies = m.addVar(vtype=GRB.CONTINUOUS, name="blueberry_pies")
milkshakes = m.addVar(vtype=GRB.CONTINUOUS, name="milkshakes")
bowls_of_cereal = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set objective function
m.setObjective(8 * hot_dogs + 7 * blueberry_pies + 8 * milkshakes + 3 * bowls_of_cereal, GRB.MINIMIZE)

# Add constraints
m.addConstr(17 * blueberry_pies + 23 * milkshakes >= 73, "protein_constraint1")
m.addConstr(22 * hot_dogs + 23 * milkshakes >= 107, "protein_constraint2")
m.addConstr(22 * hot_dogs + 17 * blueberry_pies + 23 * milkshakes + 11 * bowls_of_cereal >= 107, "protein_constraint3")
m.addConstr(22 * hot_dogs + 11 * bowls_of_cereal <= 143, "protein_constraint4")
m.addConstr(22 * hot_dogs + 23 * milkshakes <= 247, "protein_constraint5")
m.addConstr(22 * hot_dogs + 17 * blueberry_pies + 11 * bowls_of_cereal <= 222, "protein_constraint6")
m.addConstr(22 * hot_dogs + 23 * milkshakes + 11 * bowls_of_cereal <= 138, "protein_constraint7")
m.addConstr(22 * hot_dogs + 17 * blueberry_pies + 23 * milkshakes <= 166, "protein_constraint8")


m.addConstr(4 * hot_dogs + 14 * milkshakes >= 45, "calcium_constraint1")
m.addConstr(14 * milkshakes + 13 * bowls_of_cereal >= 28, "calcium_constraint2")
m.addConstr(19 * blueberry_pies + 14 * milkshakes >= 27, "calcium_constraint3")
m.addConstr(4 * hot_dogs + 19 * blueberry_pies >= 67, "calcium_constraint4")
m.addConstr(4 * hot_dogs + 13 * bowls_of_cereal >= 43, "calcium_constraint5")
m.addConstr(4 * hot_dogs + 19 * blueberry_pies + 14 * milkshakes + 13 * bowls_of_cereal >= 43, "calcium_constraint6")
m.addConstr(14 * milkshakes + 13 * bowls_of_cereal <= 187, "calcium_constraint7")

m.addConstr(-8 * hot_dogs + 8 * bowls_of_cereal >= 0, "custom_constraint1")
m.addConstr(1 * blueberry_pies - 10 * milkshakes >= 0, "custom_constraint2")


# Add resource constraints based on the provided dictionary (optional - if you want to use the dictionary data)
# resource_data = {'r0': {'upper_bound': 435, 'x0': 22, 'x1': 17, 'x2': 23, 'x3': 11}, 'r1': {'upper_bound': 315, 'x0': 4, 'x1': 19, 'x2': 14, 'x3': 13}}
# for resource, data in resource_data.items():
#     m.addConstr(data['x0'] * hot_dogs + data['x1'] * blueberry_pies + data['x2'] * milkshakes + data['x3'] * bowls_of_cereal <= data['upper_bound'], resource)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

