
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    hot_dogs = model.addVar(name="hot_dogs", vtype=gurobi.GRB.INTEGER)
    blueberry_pies = model.addVar(name="blueberry_pies")
    milkshakes = model.addVar(name="milkshakes")
    bowls_of_cereal = model.addVar(name="bowls_of_cereal", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8 * hot_dogs + 7 * blueberry_pies + 8 * milkshakes + 3 * bowls_of_cereal, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(22 * hot_dogs + 17 * blueberry_pies + 23 * milkshakes + 11 * bowls_of_cereal <= 435)
    model.addConstr(4 * hot_dogs + 19 * blueberry_pies + 14 * milkshakes + 13 * bowls_of_cereal <= 315)
    model.addConstr(17 * blueberry_pies + 23 * milkshakes >= 73)
    model.addConstr(22 * hot_dogs + 23 * milkshakes >= 107)
    model.addConstr(22 * hot_dogs + 17 * blueberry_pies + 23 * milkshakes + 11 * bowls_of_cereal >= 107)
    model.addConstr(4 * hot_dogs + 14 * milkshakes >= 45)
    model.addConstr(14 * milkshakes + 13 * bowls_of_cereal >= 28)
    model.addConstr(19 * blueberry_pies + 14 * milkshakes >= 27)
    model.addConstr(4 * hot_dogs + 19 * blueberry_pies >= 67)
    model.addConstr(4 * hot_dogs + 13 * bowls_of_cereal >= 43)
    model.addConstr(4 * hot_dogs + 19 * blueberry_pies + 14 * milkshakes + 13 * bowls_of_cereal >= 43)
    model.addConstr(-8 * hot_dogs + 8 * bowls_of_cereal >= 0)
    model.addConstr(blueberry_pies - 10 * milkshakes >= 0)
    model.addConstr(22 * hot_dogs + 11 * bowls_of_cereal <= 143)
    model.addConstr(22 * hot_dogs + 23 * milkshakes <= 247)
    model.addConstr(22 * hot_dogs + 17 * blueberry_pies + 11 * bowls_of_cereal <= 222)
    model.addConstr(22 * hot_dogs + 23 * milkshakes + 11 * bowls_of_cereal <= 138)
    model.addConstr(22 * hot_dogs + 17 * blueberry_pies + 23 * milkshakes <= 166)
    model.addConstr(14 * milkshakes + 13 * bowls_of_cereal <= 187)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hot dogs: ", hot_dogs.varValue)
        print("Blueberry pies: ", blueberry_pies.varValue)
        print("Milkshakes: ", milkshakes.varValue)
        print("Bowls of cereal: ", bowls_of_cereal.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
