
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="network administrators")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion analysts")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="Mbps bandwidth allocated to monitoring")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="patches per day")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="SOC operators")

# Set objective function
m.setObjective(7.63 * x0 + 7.32 * x1 + 7.5 * x2 + 3.2 * x3 + 1.63 * x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * x0 + 7 * x1 + 9 * x2 + 9 * x3 + 11 * x4 <= 104, "Network Integrity Impact") #r0
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 + 10 * x3 + 2 * x4 <= 114, "Power Consumption") #r1

m.addConstr(7 * x1 + 11 * x4 >= 14, "Combined Network Integrity Impact (x1, x4)")
m.addConstr(8 * x1 + 10 * x3 >= 11, "Combined Power Consumption (x1, x3)")
m.addConstr(2 * x0 + 8 * x1 >= 16, "Combined Power Consumption (x0, x1)")
m.addConstr(8 * x1 + 2 * x4 >= 9, "Combined Power Consumption (x1, x4)")
m.addConstr(11 * x2 + 10 * x3 >= 20, "Combined Power Consumption (x2, x3)")
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 >= 20, "Combined Power Consumption (x0, x1, x2)")
m.addConstr(8 * x1 + 11 * x2 + 2 * x4 >= 20, "Combined Power Consumption (x1, x2, x4)")
m.addConstr(2 * x0 + 10 * x3 + 2 * x4 >= 20, "Combined Power Consumption (x0, x3, x4)")
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 >= 11, "Combined Power Consumption (x0, x1, x2)")
m.addConstr(8 * x1 + 11 * x2 + 2 * x4 >= 11, "Combined Power Consumption (x1, x2, x4)")
m.addConstr(2 * x0 + 10 * x3 + 2 * x4 >= 11, "Combined Power Consumption (x0, x3, x4)")
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 >= 12, "Combined Power Consumption (x0, x1, x2)")
m.addConstr(8 * x1 + 11 * x2 + 2 * x4 >= 12, "Combined Power Consumption (x1, x2, x4)")
m.addConstr(2 * x0 + 10 * x3 + 2 * x4 >= 12, "Combined Power Consumption (x0, x3, x4)")

m.addConstr(-9 * x0 + 9 * x1 + 10 * x3 >= 0, "Constraint 1")
m.addConstr(9 * x2 + 9 * x3 <= 85, "Combined Network Integrity Impact (x2, x3)")
m.addConstr(10 * x0 + 9 * x3 <= 92, "Combined Network Integrity Impact (x0, x3)")
m.addConstr(7 * x1 + 9 * x2 + 9 * x3 <= 36, "Combined Network Integrity Impact (x1, x2, x3)")
m.addConstr(10 * x0 + 7 * x1 + 9 * x3 <= 54, "Combined Network Integrity Impact (x0, x1, x3)")
m.addConstr(10 * x0 + 7 * x1 + 9 * x2 + 9 * x3 + 11 * x4 <= 54, "Combined Network Integrity Impact (all)")

m.addConstr(8 * x1 + 10 * x3 <= 69, "Combined Power Consumption (x1, x3)")
m.addConstr(2 * x0 + 8 * x1 <= 70, "Combined Power Consumption (x0, x1)")
m.addConstr(2 * x0 + 2 * x4 <= 81, "Combined Power Consumption (x0, x4)")
m.addConstr(8 * x1 + 11 * x2 <= 39, "Combined Power Consumption (x1, x2)")
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 <= 44, "Combined Power Consumption (x0, x1, x2)")
m.addConstr(11 * x2 + 10 * x3 + 2 * x4 <= 27, "Combined Power Consumption (x2, x3, x4)")
m.addConstr(2 * x0 + 10 * x3 + 2 * x4 <= 108, "Combined Power Consumption (x0, x3, x4)")
m.addConstr(2 * x0 + 11 * x2 + 2 * x4 <= 56, "Combined Power Consumption (x0, x2, x4)")
m.addConstr(8 * x1 + 11 * x2 + 10 * x3 <= 70, "Combined Power Consumption (x1, x2, x3)")
m.addConstr(2 * x0 + 11 * x2 + 10 * x3 <= 105, "Combined Power Consumption (x0, x2, x3)")
m.addConstr(2 * x0 + 8 * x1 + 11 * x2 + 10 * x3 + 2 * x4 <= 105, "Combined Power Consumption (all)")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

