
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
bobby_hours = m.addVar(lb=0, name="bobby_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peggy_hours")
george_hours = m.addVar(lb=0, name="george_hours")
laura_hours = m.addVar(lb=0, name="laura_hours")

# Set objective function
m.setObjective(5.26 * bobby_hours + 4.69 * peggy_hours + 6.55 * george_hours + 5.86 * laura_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * peggy_hours + 14 * george_hours >= 10, "c1")
m.addConstr(2 * bobby_hours + 14 * george_hours + 8 * laura_hours >= 21, "c2")
m.addConstr(9 * peggy_hours + 14 * george_hours + 8 * laura_hours >= 21, "c3")
m.addConstr(2 * bobby_hours + 14 * george_hours + 8 * laura_hours >= 13, "c4")
m.addConstr(9 * peggy_hours + 14 * george_hours + 8 * laura_hours >= 13, "c5")
m.addConstr(2 * bobby_hours + 9 * peggy_hours + 14 * george_hours + 8 * laura_hours >= 13, "c6")
m.addConstr(12 * peggy_hours + 7 * laura_hours >= 10, "c7")
m.addConstr(11 * bobby_hours + 3 * george_hours >= 15, "c8")
m.addConstr(11 * bobby_hours + 12 * peggy_hours >= 7, "c9")
m.addConstr(12 * peggy_hours + 3 * george_hours + 7 * laura_hours >= 14, "c10")
m.addConstr(11 * bobby_hours + 12 * peggy_hours + 7 * laura_hours >= 14, "c11")
m.addConstr(12 * peggy_hours + 3 * george_hours + 7 * laura_hours >= 16, "c12")
m.addConstr(11 * bobby_hours + 12 * peggy_hours + 7 * laura_hours >= 16, "c13")
m.addConstr(11 * bobby_hours + 12 * peggy_hours + 3 * george_hours + 7 * laura_hours >= 16, "c14")
m.addConstr(-2 * george_hours + 9 * laura_hours >= 0, "c15")
m.addConstr(6 * bobby_hours - 8 * peggy_hours >= 0, "c16")
m.addConstr(9 * peggy_hours + 14 * george_hours <= 77, "c17")
m.addConstr(14 * george_hours + 8 * laura_hours <= 34, "c18")
m.addConstr(2 * bobby_hours + 9 * peggy_hours <= 25, "c19")
m.addConstr(11 * bobby_hours + 3 * george_hours + 7 * laura_hours <= 26, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
