
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # No upper bound given
    x1 = model.addVar(name="hours_worked_by_Peggy", lb=0, integrality=1)  # Must be integer
    x2 = model.addVar(name="hours_worked_by_George", lb=0)  # No upper bound given
    x3 = model.addVar(name="hours_worked_by_Laura", lb=0)  # No upper bound given

    # Objective function
    model.setObjective(5.26*x0 + 4.69*x1 + 6.55*x2 + 5.86*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    # Paperwork competence rating constraints
    model.addConstr(9*x1 + 14*x2 >= 10, name="paperwork_Peggy_George")
    model.addConstr(2*x0 + 14*x2 + 8*x3 >= 21, name="paperwork_Bobby_George_Laura")
    model.addConstr(9*x1 + 14*x2 + 8*x3 >= 21, name="paperwork_Peggy_George_Laura_combined")
    model.addConstr(2*x0 + 14*x2 + 8*x3 >= 13, name="paperwork_Bobby_George_Laura_min")
    model.addConstr(9*x1 + 14*x2 + 8*x3 >= 13, name="paperwork_Peggy_George_Laura_min")
    model.addConstr(2*x0 + 9*x1 + 14*x2 + 8*x3 >= 13, name="paperwork_all")

    # Computer competence rating constraints
    model.addConstr(12*x1 + 7*x3 >= 10, name="computer_Peggy_Laura")
    model.addConstr(11*x0 + 3*x2 >= 15, name="computer_Bobby_George")
    model.addConstr(11*x0 + 12*x1 >= 7, name="computer_Bobby_Peggy")
    model.addConstr(12*x1 + 3*x2 + 7*x3 >= 14, name="computer_Peggy_George_Laura")
    model.addConstr(11*x0 + 12*x1 + 7*x3 >= 14, name="computer_Bobby_Peggy_Laura")
    model.addConstr(12*x1 + 3*x2 + 7*x3 >= 16, name="computer_Peggy_George_Laura_min16")
    model.addConstr(11*x0 + 12*x1 + 7*x3 >= 16, name="computer_Bobby_Peggy_Laura_min16")
    model.addConstr(11*x0 + 12*x1 + 3*x2 + 7*x3 >= 16, name="computer_all")

    # Additional constraints
    model.addConstr(-2*x2 + 9*x3 >= 0, name="George_Laura_constraint")
    model.addConstr(6*x0 - 8*x1 >= 0, name="Bobby_Peggy_constraint")
    model.addConstr(9*x1 + 14*x2 <= 77, name="paperwork_Peggy_George_max")
    model.addConstr(14*x2 + 8*x3 <= 34, name="paperwork_George_Laura_max")
    model.addConstr(2*x0 + 9*x1 <= 25, name="paperwork_Bobby_Peggy_max")
    model.addConstr(11*x0 + 3*x2 + 7*x3 <= 26, name="computer_Bobby_George_Laura_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Peggy: ", x1.varValue)
        print("Hours worked by George: ", x2.varValue)
        print("Hours worked by Laura: ", x3.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
