
from gurobipy import Model, GRB

# Create a new model
m = Model("Work Optimization")

# Create variables
george = m.addVar(lb=0, name="George", type=GRB.CONTINUOUS)
paul = m.addVar(lb=0, name="Paul", type=GRB.INTEGER)
laura = m.addVar(lb=0, name="Laura", type=GRB.CONTINUOUS)
ringo = m.addVar(lb=0, name="Ringo", type=GRB.INTEGER)
hank = m.addVar(lb=0, name="Hank", type=GRB.INTEGER)

# Set objective function
m.setObjective(8.72 * george + 6.37 * paul + 8.49 * laura + 2.59 * ringo + 1.75 * hank, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * george + 8 * paul >= 34, "c1")
m.addConstr(5 * george + 1 * hank >= 50, "c2")
m.addConstr(5 * george + 6 * ringo >= 64, "c3")
m.addConstr(6 * ringo + 1 * hank >= 72, "c4")
m.addConstr(8 * paul + 6 * ringo >= 59, "c5")
m.addConstr(5 * george + 8 * paul + 1 * hank >= 52, "c6")
m.addConstr(5 * george + 8 * paul + 11 * laura + 6 * ringo + 1 * hank >= 52, "c7")
m.addConstr(4 * laura + 14 * hank >= 81, "c8")
m.addConstr(10 * george + 4 * laura >= 82, "c9")
m.addConstr(10 * george + 6 * paul >= 78, "c10")
m.addConstr(7 * ringo + 14 * hank >= 84, "c11")
m.addConstr(6 * paul + 4 * laura >= 75, "c12")
m.addConstr(10 * george + 6 * paul + 4 * laura + 7 * ringo + 14 * hank >= 75, "c13")
m.addConstr(17 * laura + 6 * ringo >= 21, "c14")
m.addConstr(3 * george + 2 * paul >= 20, "c15")
m.addConstr(3 * george + 12 * hank >= 11, "c16")
m.addConstr(17 * laura + 6 * ringo + 12 * hank >= 28, "c17")
m.addConstr(3 * george + 2 * paul + 17 * laura + 6 * ringo + 12 * hank >= 28, "c18")
m.addConstr(-10 * george + 6 * laura >= 0, "c19")
m.addConstr(-5 * paul + 3 * hank >= 0, "c20")

m.addConstr(8 * paul + 11 * laura <= 117, "c21")
m.addConstr(5 * george + 6 * ringo <= 272, "c22")
m.addConstr(8 * paul + 6 * ringo <= 232, "c23")
m.addConstr(11 * laura + 6 * ringo <= 371, "c24")
m.addConstr(8 * paul + 1 * hank <= 369, "c25")
m.addConstr(5 * george + 11 * laura + 1 * hank <= 196, "c26")
m.addConstr(5 * george + 11 * laura + 6 * ringo <= 334, "c27")
m.addConstr(6 * paul + 4 * laura <= 284, "c28")
m.addConstr(4 * laura + 7 * ringo <= 218, "c29")
m.addConstr(10 * george + 14 * hank <= 102, "c30")
m.addConstr(10 * george + 6 * paul <= 135, "c31")
m.addConstr(10 * george + 4 * laura <= 264, "c32")
m.addConstr(10 * george + 7 * ringo <= 280, "c33")
m.addConstr(10 * george + 6 * paul + 4 * laura <= 278, "c34")
m.addConstr(10 * george + 4 * laura + 14 * hank <= 318, "c35")
m.addConstr(6 * paul + 4 * laura + 14 * hank <= 364, "c36")
m.addConstr(2 * paul + 17 * laura <= 50, "c37")
m.addConstr(3 * george + 6 * ringo <= 98, "c38")
m.addConstr(2 * paul + 12 * hank <= 83, "c39")
m.addConstr(6 * ringo + 12 * hank <= 51, "c40")
m.addConstr(2 * paul + 6 * ringo <= 102, "c41")
m.addConstr(2 * paul + 17 * laura + 12 * hank <= 67, "c42")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
