
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
bagged_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagged_salads")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
slices_pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_pizza")

# Set objective function
m.setObjective(7 * chicken_thighs + 5 * bagged_salads + 5 * apples + 9 * knishes + 3 * slices_pizza, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2 * bagged_salads + 16 * knishes >= 28, "c1")
m.addConstr(2 * chicken_thighs + 15 * apples >= 37, "c2")
m.addConstr(15 * apples + 16 * knishes >= 33, "c3")
m.addConstr(2 * chicken_thighs + 7 * slices_pizza >= 37, "c4")
m.addConstr(16 * knishes + 7 * slices_pizza >= 21, "c5")
m.addConstr(2 * bagged_salads + 15 * apples >= 39, "c6")
m.addConstr(2 * chicken_thighs + 16 * knishes + 7 * slices_pizza >= 29, "c7")
m.addConstr(2 * chicken_thighs + 2 * bagged_salads + 15 * apples + 16 * knishes + 7 * slices_pizza >= 29, "c8")
m.addConstr(2 * knishes - 10 * slices_pizza >= 0, "c9")
m.addConstr(15 * apples + 16 * knishes <= 64, "c10")
m.addConstr(2 * bagged_salads + 15 * apples + 16 * knishes <= 196, "c11")
m.addConstr(2 * chicken_thighs + 2 * bagged_salads + 7 * slices_pizza <= 153, "c12")
m.addConstr(2 * chicken_thighs + 2 * bagged_salads + 15 * apples <= 86, "c13")
m.addConstr(2 * chicken_thighs + 2 * bagged_salads + 15 * apples + 16 * knishes + 7 * slices_pizza <= 207, "calcium_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

