
from gurobipy import Model, GRB

# Create a new model
m = Model("Military Optimization")

# Create variables
lic = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
sp = m.addVar(vtype=GRB.INTEGER, name="signal_platoons")
lc = m.addVar(vtype=GRB.INTEGER, name="logistics_companies")
mp = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")

# Set objective function
m.setObjective(2*lic**2 + 6*lic*sp + 3*lic*lc + 4*sp**2 + 8*sp*mp + 6*lc**2 + 8*lc*mp + 4*sp + 6*lc + 9*mp, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*lic + 26*sp + 3*lc + 22*mp <= 136, "Logistical Capacity")  # Resource r0
m.addConstr(11*lic + 15*sp + 10*lc + 20*mp <= 176, "Fuel Demand")  # Resource r1

m.addConstr((13*lic)**2 + (3*lc)**2 + (22*mp)**2 >= 30, "Combined Logistical Capacity 1")
m.addConstr(11*lic + 20*mp >= 38, "Fuel Demand 1")
m.addConstr(10*lc + 20*mp >= 31, "Fuel Demand 2")
m.addConstr(15*sp + 10*lc >= 33, "Fuel Demand 3")

m.addConstr(13*lic + 3*lc <= 113, "Combined Logistical Capacity 2")
m.addConstr(3*lc + 22*mp <= 110, "Combined Logistical Capacity 3")
m.addConstr(13*lic + 22*mp <= 105, "Combined Logistical Capacity 4")
m.addConstr(13*lic + 26*sp + 3*lc + 22*mp <= 105, "Combined Logistical Capacity 5")

m.addConstr((11*lic)**2 + (15*sp)**2 <= 161, "Fuel Demand 4")
m.addConstr((15*sp)**2 + (20*mp)**2 <= 133, "Fuel Demand 5")
m.addConstr((15*sp)**2 + (10*lc)**2 <= 92, "Fuel Demand 6")
m.addConstr(10*lc + 20*mp <= 174, "Fuel Demand 7")
m.addConstr(11*lic + 20*mp <= 61, "Fuel Demand 8")
m.addConstr(15*sp + 10*lc + 20*mp <= 168, "Fuel Demand 9")
m.addConstr((11*lic)**2 + (15*sp)**2 + (10*lc)**2 <= 82, "Fuel Demand 10")
m.addConstr(11*lic + 15*sp + 10*lc + 20*mp <= 82, "Fuel Demand 11")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % m.status)

