
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    laura_hours = m.addVar(lb=0, name="laura_hours")  # Continuous
    john_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="john_hours") # Integer

    # Set objective function
    m.setObjective(1.13 * laura_hours**2 + 5.24 * john_hours**2 + 1.28 * john_hours, GRB.MAXIMIZE)

    # Add constraints

    # Individual resource constraints (These are fixed and don't affect the optimization)
    # m.addConstr(9 * laura_hours == 9)  # Laura's likelihood to quit index
    # m.addConstr(21 * laura_hours == 21) # Laura's productivity rating
    # m.addConstr(26 * laura_hours == 26) # Laura's work quality rating
    # m.addConstr(14 * john_hours == 14) # John's likelihood to quit index
    # m.addConstr(23 * john_hours == 23) # John's productivity rating
    # m.addConstr(16 * john_hours == 16) # John's work quality rating


    # Combined resource constraints
    m.addConstr(9 * laura_hours + 14 * john_hours >= 71, "combined_likelihood_lower")
    m.addConstr(21 * laura_hours + 23 * john_hours >= 62, "combined_productivity_lower")
    m.addConstr(26 * laura_hours**2 + 16 * john_hours**2 >= 66, "combined_work_quality_lower")
    m.addConstr(3 * laura_hours - 7 * john_hours >= 0, "linear_combination")

    m.addConstr(9 * laura_hours + 14 * john_hours <= 198, "combined_likelihood_upper")
    m.addConstr(9 * laura_hours + 14 * john_hours <= 198, "combined_likelihood_upper2") # Redundant
    m.addConstr(21 * laura_hours + 23 * john_hours <= 168, "combined_productivity_upper")
    m.addConstr(21 * laura_hours + 23 * john_hours <= 168, "combined_productivity_upper2") # Redundant
    m.addConstr(26 * laura_hours + 16 * john_hours <= 121, "combined_work_quality_upper")
    m.addConstr(26 * laura_hours + 16 * john_hours <= 121, "combined_work_quality_upper2") # Redundant


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Laura Hours: %g' % laura_hours.x)
        print('John Hours: %g' % john_hours.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
