
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
laura_hours = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="laura_hours")
john_hours = m.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="john_hours")

# Objective function
m.setObjective(1.13 * laura_hours ** 2 + 5.24 * john_hours ** 2 + 1.28 * john_hours, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(9 * laura_hours + 14 * john_hours >= 71, name="likelihood_to_quit_index")
m.addConstr(21 * laura_hours + 23 * john_hours >= 62, name="productivity_rating")
m.addConstr(26 * laura_hours ** 2 + 16 * john_hours ** 2 >= 66, name="work_quality_rating")
m.addConstr(3 * laura_hours - 7 * john_hours >= 0, name="hours_worked_constraint")
m.addConstr(9 * laura_hours + 14 * john_hours <= 198, name="likelihood_to_quit_index_max")
m.addConstr(21 * laura_hours + 23 * john_hours <= 168, name="productivity_rating_max")
m.addConstr(26 * laura_hours ** 2 + 16 * john_hours ** 2 <= 121, name="work_quality_rating_max")

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Laura's hours: {laura_hours.varValue}")
    print(f"John's hours: {john_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
