
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
steaks = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")
peanutbutter_sandwiches = m.addVar(vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
ham_sandwiches = m.addVar(vtype=GRB.CONTINUOUS, name="ham_sandwiches")
pickles = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")
chicken_drumsticks = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")

# Set objective function
m.setObjective(5.13 * steaks + 3.46 * peanutbutter_sandwiches + 4.8 * ham_sandwiches + 8.09 * pickles + 4.59 * chicken_drumsticks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21, "c1")
m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21, "c2")
m.addConstr(-8 * peanutbutter_sandwiches + 3 * pickles + 8 * chicken_drumsticks >= 0, "c3")
m.addConstr(7 * ham_sandwiches + 9 * chicken_drumsticks <= 46, "c4")
m.addConstr(8 * steaks + 9 * chicken_drumsticks <= 28, "c5")
m.addConstr(6 * peanutbutter_sandwiches + 9 * pickles <= 106, "c6")
m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 9 * pickles <= 110, "c7")
m.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches + 9 * pickles + 9 * chicken_drumsticks <= 110, "c8")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

