
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
steaks = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")
peanutbutter_sandwiches = m.addVar(vtype=GRB.CONTINUOUS, name="peanutbutter_sandwiches")
ham_sandwiches = m.addVar(vtype=GRB.CONTINUOUS, name="ham_sandwiches")
pickles = m.addVar(vtype=GRB.CONTINUOUS, name="pickles")
chicken_drumsticks = m.addVar(vtype=GRB.CONTINUOUS, name="chicken_drumsticks")

# Define the objective function
m.setObjective(5.13*steaks + 3.46*peanutbutter_sandwiches + 4.8*ham_sandwiches + 8.09*pickles + 4.59*chicken_drumsticks, GRB.MAXIMIZE)

# Add constraints
# Minimum spending on peanut butter sandwiches and ham sandwiches
m.addConstr(6*peanutbutter_sandwiches + 7*ham_sandwiches >= 21, name="min_spending_pb_ham")

# Minimum spending on steaks, peanut butter sandwiches, and ham sandwiches
m.addConstr(8*steaks + 6*peanutbutter_sandwiches + 7*ham_sandwiches >= 21, name="min_spending_steaks_pb_ham")

# Constraint involving quantities
m.addConstr(-8*peanutbutter_sandwiches + 3*pickles + 8*chicken_drumsticks >= 0, name="quantity_constraint")

# Maximum spending constraints
m.addConstr(7*ham_sandwiches + 9*chicken_drumsticks <= 46, name="max_spending_ham_chicken")
m.addConstr(8*steaks + 9*chicken_drumsticks <= 28, name="max_spending_steaks_chicken")
m.addConstr(6*peanutbutter_sandwiches + 9*pickles <= 106, name="max_spending_pb_pickles")
m.addConstr(8*steaks + 6*peanutbutter_sandwiches + 9*pickles <= 110, name="max_spending_steaks_pb_pickles")
m.addConstr(8*steaks + 6*peanutbutter_sandwiches + 7*ham_sandwiches + 9*pickles + 9*chicken_drumsticks <= 141, name="total_max_spending")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Steaks:", steaks.x)
    print("Peanut butter sandwiches:", peanutbutter_sandwiches.x)
    print("Ham sandwiches:", ham_sandwiches.x)
    print("Pickles:", pickles.x)
    print("Chicken drumsticks:", chicken_drumsticks.x)
else:
    print("No optimal solution found.")
