
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    steaks = model.addVar(name="steaks", lb=0, ub=gurobi.GRB.INFINITY)
    peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)
    ham_sandwiches = model.addVar(name="ham_sandwiches", lb=0, ub=gurobi.GRB.INFINITY)
    pickles = model.addVar(name="pickles", lb=0, ub=gurobi.GRB.INFINITY)
    chicken_drumsticks = model.addVar(name="chicken_drumsticks", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(5.13 * steaks + 3.46 * peanutbutter_sandwiches + 4.8 * ham_sandwiches + 8.09 * pickles + 4.59 * chicken_drumsticks, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21)  # At least $21 on peanutbutter and ham sandwiches
    model.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches >= 21)  # At least $21 on steaks, peanutbutter, and ham
    model.addConstr(-8 * peanutbutter_sandwiches + 3 * pickles + 8 * chicken_drumsticks >= 0)  # Specific constraint
    model.addConstr(7 * ham_sandwiches + 9 * chicken_drumsticks <= 46)  # No more than $46 on ham and chicken
    model.addConstr(8 * steaks + 9 * chicken_drumsticks <= 28)  # No more than $28 on steaks and chicken
    model.addConstr(6 * peanutbutter_sandwiches + 9 * pickles <= 106)  # No more than $106 on peanutbutter and pickles
    model.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 9 * pickles <= 110)  # No more than $110 on steaks, peanutbutter, and pickles
    model.addConstr(8 * steaks + 6 * peanutbutter_sandwiches + 7 * ham_sandwiches + 9 * pickles + 9 * chicken_drumsticks <= 110)  # No more than $110 total

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Steaks: ", steaks.x)
        print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.x)
        print("Ham sandwiches: ", ham_sandwiches.x)
        print("Pickles: ", pickles.x)
        print("Chicken drumsticks: ", chicken_drumsticks.x)
    else:
        print("The model is infeasible")

optimization_problem()
