
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkOptimization")

# Create variables
ringo_hours = model.addVar(vtype=GRB.INTEGER, name="ringo_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
peggy_hours = model.addVar(vtype=GRB.INTEGER, name="peggy_hours")

# Set objective function
model.setObjective(5*ringo_hours + 4*paul_hours + 4*hank_hours + 5*peggy_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(17*ringo_hours + 23*paul_hours >= 60, "c1")
model.addConstr(17*ringo_hours + 6*hank_hours >= 35, "c2")
model.addConstr(23*paul_hours + 6*hank_hours + 17*peggy_hours >= 77, "c3")
model.addConstr(17*ringo_hours + 23*paul_hours + 6*hank_hours + 17*peggy_hours >= 77, "c4")

model.addConstr(7*ringo_hours + 18*hank_hours >= 19, "c5")
model.addConstr(23*paul_hours + 19*peggy_hours >= 24, "c6")
model.addConstr(7*ringo_hours + 19*peggy_hours >= 36, "c7")
model.addConstr(7*ringo_hours + 23*paul_hours + 19*peggy_hours >= 35, "c8")
model.addConstr(7*ringo_hours + 23*paul_hours + 18*hank_hours >= 35, "c9")
model.addConstr(7*ringo_hours + 23*paul_hours + 19*peggy_hours >= 37, "c10")
model.addConstr(7*ringo_hours + 23*paul_hours + 18*hank_hours >= 37, "c11")
model.addConstr(7*ringo_hours + 23*paul_hours + 18*hank_hours + 19*peggy_hours >= 37, "c12")

model.addConstr(4*paul_hours - 8*hank_hours >= 0, "c13")
model.addConstr(-8*paul_hours + 10*peggy_hours >= 0, "c14")
model.addConstr(-7*ringo_hours + 9*hank_hours + 10*peggy_hours >= 0, "c15")

model.addConstr(17*ringo_hours + 23*paul_hours + 17*peggy_hours <= 231, "c16")
model.addConstr(17*ringo_hours + 6*hank_hours + 17*peggy_hours <= 104, "c17")
model.addConstr(23*paul_hours + 6*hank_hours + 17*peggy_hours <= 96, "c18")
model.addConstr(17*ringo_hours + 23*paul_hours + 6*hank_hours <= 276, "c19")

model.addConstr(7*ringo_hours + 23*paul_hours <= 58, "c20")
model.addConstr(23*paul_hours + 18*hank_hours <= 118, "c21")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

