
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
ringo = model.addVar(name="Ringo", vtype=gurobi.GRB.INTEGER)
paul = model.addVar(name="Paul", vtype=gurobi.GRB.INTEGER)
hank = model.addVar(name="Hank", vtype=gurobi.GRB.INTEGER)
peggy = model.addVar(name="Peggy", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(5 * ringo + 4 * paul + 4 * hank + 5 * peggy, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(ringo >= 0, name="Ringo_non_negative")
model.addConstr(paul >= 0, name="Paul_non_negative")
model.addConstr(hank >= 0, name="Hank_non_negative")
model.addConstr(peggy >= 0, name="Peggy_non_negative")

# Organization and work quality ratings (not directly constraints but given)
# Ringo's organization score is 17, work quality rating is 7
# Paul's organization score is 23, work quality rating is 23
# Hank's organization score is 6, work quality rating is 18
# Peggy's organization score is 17, work quality rating is 19

# Constraints from problem description
model.addConstr(17 * ringo + 23 * paul >= 60)
model.addConstr(17 * ringo + 6 * hank >= 35)
model.addConstr(23 * paul + 6 * hank + 17 * peggy >= 77)
model.addConstr(17 * ringo + 23 * paul + 6 * hank + 17 * peggy >= 77)
model.addConstr(7 * ringo + 18 * hank >= 19)
model.addConstr(23 * paul + 19 * peggy >= 24)
model.addConstr(7 * ringo + 19 * peggy >= 36)
model.addConstr(7 * ringo + 23 * paul + 19 * peggy >= 35)
model.addConstr(7 * ringo + 23 * paul + 18 * hank >= 35)
model.addConstr(7 * ringo + 23 * paul + 18 * hank + 19 * peggy >= 37)
model.addConstr(4 * paul - 8 * hank >= 0)
model.addConstr(-8 * paul + 10 * peggy >= 0)
model.addConstr(-7 * ringo + 9 * hank + 10 * peggy >= 0)
model.addConstr(17 * ringo + 23 * paul + 17 * peggy <= 231)
model.addConstr(17 * ringo + 6 * hank + 17 * peggy <= 104)
model.addConstr(23 * paul + 6 * hank + 17 * peggy <= 96)
model.addConstr(17 * ringo + 23 * paul + 6 * hank <= 276)
model.addConstr(7 * ringo + 23 * paul <= 58)
model.addConstr(23 * paul + 18 * hank <= 118)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Ringo: ", ringo.varValue)
    print("Paul: ", paul.varValue)
    print("Hank: ", hank.varValue)
    print("Peggy: ", peggy.varValue)
else:
    print("The model is infeasible")
