
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
john = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
ringo = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo")

# Set objective function
m.setObjective(9*john + 2*laura + 5*hank + 2*ringo, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7*hank + 5*ringo >= 57, "c1")
m.addConstr(22*john + 5*ringo >= 25, "c2")
m.addConstr(22*john + 6*laura >= 23, "c3")
m.addConstr(22*john + 7*hank + 5*ringo >= 41, "c4")
m.addConstr(22*john + 6*laura + 7*hank >= 41, "c5")
m.addConstr(22*john + 7*hank + 5*ringo >= 45, "c6")
m.addConstr(22*john + 6*laura + 7*hank >= 45, "c7")
m.addConstr(22*john + 6*laura + 7*hank + 5*ringo >= 45, "c8")
m.addConstr(32*john + 9*laura >= 87, "c9")
m.addConstr(32*john + 28*hank >= 61, "c10")
m.addConstr(9*laura + 28*hank >= 49, "c11")
m.addConstr(32*john + 9*laura + 28*hank + 28*ringo >= 49, "c12")
m.addConstr(-8*laura + 5*ringo >= 0, "c13")
m.addConstr(-1*laura + 10*hank >= 0, "c14")
m.addConstr(22*john + 6*laura + 7*hank <= 239, "c15")
m.addConstr(9*laura + 28*ringo <= 430, "c16")
m.addConstr(32*john + 28*ringo <= 384, "c17")
m.addConstr(32*john + 9*laura <= 313, "c18")
m.addConstr(9*laura + 28*hank <= 130, "c19")
m.addConstr(28*hank + 28*ringo <= 193, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

