
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_John", lb=0)  # hours worked by John
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)  # hours worked by Laura
x2 = m.addVar(name="hours_worked_by_Hank", lb=0)  # hours worked by Hank
x3 = m.addVar(name="hours_worked_by_Ringo", lb=0)  # hours worked by Ringo

# Define the objective function
m.setObjective(9 * x0 + 2 * x1 + 5 * x2 + 2 * x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * x0 + 6 * x1 + 7 * x2 + 5 * x3 >= 57)  
m.addConstr(22 * x0 + 5 * x3 >= 25)  
m.addConstr(22 * x0 + 6 * x1 >= 23)  
m.addConstr(22 * x0 + 7 * x2 + 5 * x3 >= 41)  
m.addConstr(22 * x0 + 6 * x1 + 7 * x2 >= 41)  
m.addConstr(22 * x0 + 7 * x2 + 5 * x3 >= 45)  
m.addConstr(22 * x0 + 6 * x1 + 7 * x2 >= 45)  
m.addConstr(22 * x0 + 6 * x1 + 7 * x2 + 5 * x3 >= 45)  
m.addConstr(32 * x0 + 9 * x1 >= 87)  
m.addConstr(32 * x0 + 28 * x2 >= 61)  
m.addConstr(9 * x1 + 28 * x2 >= 49)  
m.addConstr(32 * x0 + 9 * x1 + 28 * x2 + 28 * x3 >= 49)  
m.addConstr(-8 * x1 + 5 * x3 >= 0)  
m.addConstr(-x1 + 10 * x2 >= 0)  
m.addConstr(22 * x0 + 6 * x1 + 7 * x2 <= 239)  
m.addConstr(9 * x1 + 28 * x3 <= 430)  
m.addConstr(32 * x0 + 28 * x3 <= 384)  
m.addConstr(32 * x0 + 9 * x1 <= 313)  
m.addConstr(9 * x1 + 28 * x2 <= 130)  
m.addConstr(28 * x2 + 28 * x3 <= 193)  

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", x0.varValue)
    print("Hours worked by Laura: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by Ringo: ", x3.varValue)
else:
    print("The model is infeasible")
