
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
hot_dogs = m.addVar(lb=0, name="hot_dogs")
pizza_slices = m.addVar(lb=0, name="pizza_slices")
chicken_drumsticks = m.addVar(lb=0, name="chicken_drumsticks")

# Set objective function
m.setObjective(2 * hot_dogs + 9 * pizza_slices + 6 * chicken_drumsticks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.97 * hot_dogs + 0.94 * pizza_slices + 0.45 * chicken_drumsticks <= 53, "fat_total")  # r0
m.addConstr(0.69 * hot_dogs + 3.25 * pizza_slices + 1.51 * chicken_drumsticks <= 42, "healthiness_total")  # r1
m.addConstr(2.7 * hot_dogs + 2.23 * pizza_slices + 4.0 * chicken_drumsticks <= 36, "carbs_total")  # r2
m.addConstr(1.64 * hot_dogs + 3.26 * pizza_slices + 4.61 * chicken_drumsticks <= 35, "protein_total")  # r3
m.addConstr(4.59 * hot_dogs + 0.72 * pizza_slices + 3.06 * chicken_drumsticks <= 43, "iron_total")  # r4

m.addConstr(0.69 * hot_dogs + 3.25 * pizza_slices + 1.51 * chicken_drumsticks >= 11, "healthiness_min")
m.addConstr(2.7 * hot_dogs + 2.23 * pizza_slices >= 5, "carbs_hot_dogs_pizza_min")
m.addConstr(1.64 * hot_dogs + 3.26 * pizza_slices + 4.61 * chicken_drumsticks >= 10, "protein_min")
m.addConstr(4.59 * hot_dogs + 0.72 * pizza_slices + 3.06 * chicken_drumsticks >= 10, "iron_min")

m.addConstr(0.94 * pizza_slices + 0.45 * chicken_drumsticks <= 37, "fat_pizza_chicken_max")
m.addConstr(4.97 * hot_dogs + 0.45 * chicken_drumsticks <= 41, "fat_hot_dogs_chicken_max")
m.addConstr(4.97 * hot_dogs + 0.94 * pizza_slices <= 28, "fat_hot_dogs_pizza_max")
m.addConstr(4.97 * hot_dogs + 0.94 * pizza_slices + 0.45 * chicken_drumsticks <= 28, "fat_max")

m.addConstr(0.69 * hot_dogs + 1.51 * chicken_drumsticks <= 41, "healthiness_hot_dogs_chicken_max")
m.addConstr(3.25 * pizza_slices + 1.51 * chicken_drumsticks <= 29, "healthiness_pizza_chicken_max")
m.addConstr(0.69 * hot_dogs + 3.25 * pizza_slices + 1.51 * chicken_drumsticks <= 29, "healthiness_max")

m.addConstr(2.23 * pizza_slices + 4.0 * chicken_drumsticks <= 18, "carbs_pizza_chicken_max")
m.addConstr(2.7 * hot_dogs + 2.23 * pizza_slices + 4.0 * chicken_drumsticks <= 18, "carbs_max")

m.addConstr(3.26 * pizza_slices + 4.61 * chicken_drumsticks <= 22, "protein_pizza_chicken_max")
m.addConstr(1.64 * hot_dogs + 4.61 * chicken_drumsticks <= 26, "protein_hot_dogs_chicken_max")
m.addConstr(1.64 * hot_dogs + 3.26 * pizza_slices + 4.61 * chicken_drumsticks <= 26, "protein_max")

m.addConstr(4.59 * hot_dogs + 0.72 * pizza_slices <= 18, "iron_hot_dogs_pizza_max")
m.addConstr(0.72 * pizza_slices + 3.06 * chicken_drumsticks <= 25, "iron_pizza_chicken_max")
m.addConstr(4.59 * hot_dogs + 0.72 * pizza_slices + 3.06 * chicken_drumsticks <= 25, "iron_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

