
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    hot_dogs = model.addVar(name="hot_dogs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    slices_of_pizza = model.addVar(name="slices_of_pizza", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    chicken_drumsticks = model.addVar(name="chicken_drumsticks", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(2 * hot_dogs + 9 * slices_of_pizza + 6 * chicken_drumsticks, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Fat
    model.addConstr(4.97 * hot_dogs + 0.94 * slices_of_pizza + 0.45 * chicken_drumsticks <= 53, name="fat_constraint")
    model.addConstr(0.94 * slices_of_pizza + 0.45 * chicken_drumsticks <= 37, name="fat_slices_chicken_constraint")
    model.addConstr(4.97 * hot_dogs + 0.45 * chicken_drumsticks <= 41, name="fat_hotdogs_chicken_constraint")
    model.addConstr(4.97 * hot_dogs + 0.94 * slices_of_pizza <= 28, name="fat_hotdogs_slices_constraint")
    model.addConstr(4.97 * hot_dogs + 0.94 * slices_of_pizza + 0.45 * chicken_drumsticks <= 28, name="total_fat_constraint")

    # Healthiness Rating
    model.addConstr(0.69 * hot_dogs + 3.25 * slices_of_pizza + 1.51 * chicken_drumsticks >= 11, name="healthiness_rating_constraint")
    model.addConstr(0.69 * hot_dogs + 1.51 * chicken_drumsticks <= 41, name="healthiness_hotdogs_chicken_constraint")
    model.addConstr(3.25 * slices_of_pizza + 1.51 * chicken_drumsticks <= 29, name="healthiness_slices_chicken_constraint")
    model.addConstr(0.69 * hot_dogs + 3.25 * slices_of_pizza + 1.51 * chicken_drumsticks <= 29, name="total_healthiness_constraint")

    # Carbohydrates
    model.addConstr(2.7 * hot_dogs + 2.23 * slices_of_pizza + 4.0 * chicken_drumsticks <= 36, name="carbohydrates_constraint")
    model.addConstr(2.23 * slices_of_pizza + 4.0 * chicken_drumsticks <= 18, name="carbohydrates_slices_chicken_constraint")
    model.addConstr(2.7 * hot_dogs + 2.23 * slices_of_pizza + 4.0 * chicken_drumsticks <= 18, name="total_carbohydrates_constraint")

    # Protein
    model.addConstr(1.64 * hot_dogs + 3.26 * slices_of_pizza + 4.61 * chicken_drumsticks <= 35, name="protein_constraint")
    model.addConstr(3.26 * slices_of_pizza + 4.61 * chicken_drumsticks <= 22, name="protein_slices_chicken_constraint")
    model.addConstr(1.64 * hot_dogs + 4.61 * chicken_drumsticks <= 26, name="protein_hotdogs_chicken_constraint")
    model.addConstr(1.64 * hot_dogs + 3.26 * slices_of_pizza + 4.61 * chicken_drumsticks <= 26, name="total_protein_constraint")

    # Iron
    model.addConstr(4.59 * hot_dogs + 0.72 * slices_of_pizza + 3.06 * chicken_drumsticks <= 43, name="iron_constraint")
    model.addConstr(4.59 * hot_dogs + 0.72 * slices_of_pizza <= 18, name="iron_hotdogs_slices_constraint")
    model.addConstr(0.72 * slices_of_pizza + 3.06 * chicken_drumsticks <= 25, name="iron_slices_chicken_constraint")
    model.addConstr(4.59 * hot_dogs + 0.72 * slices_of_pizza + 3.06 * chicken_drumsticks <= 25, name="total_iron_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hot Dogs: ", hot_dogs.x)
        print("Slices of Pizza: ", slices_of_pizza.x)
        print("Chicken Drumsticks: ", chicken_drumsticks.x)
    else:
        print("The model is infeasible.")

solve_optimization_problem()
