
from gurobipy import Model, GRB

# Create a new model
model = Model("maximize_paper_plates_and_napkins")

# Create variables
paper_plates = model.addVar(vtype=GRB.INTEGER, name="paper_plates")
napkins = model.addVar(vtype=GRB.INTEGER, name="napkins")

# Set objective function
model.setObjective(2.53 * paper_plates + 1.37 * napkins, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * paper_plates + 9 * napkins >= 33, "c0")
model.addConstr(10 * paper_plates - 10 * napkins >= 0, "c1")
model.addConstr(7 * paper_plates + 9 * napkins <= 47, "c2")
model.addConstr(7 * paper_plates + 9 * napkins <= 47, "c3")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Number of packs of paper plates: {paper_plates.x}")
    print(f"Number of packs of napkins: {napkins.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

