
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")

# Set the objective function
m.setObjective(2.53*x0 + 1.37*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x0 + 9*x1 >= 33, "min_sustainability_score")
m.addConstr(10*x0 - 10*x1 >= 0, "balance_constraint")
m.addConstr(7*x0 + 9*x1 <= 47, "max_sustainability_score")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of paper plates: {x0.x}")
    print(f"Packs of napkins: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
