
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 2.53*x0 + 1.37*x1
    model.setObjective(2.53 * x0 + 1.37 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x0 + 9 * x1 >= 33, name="sustainability_score_min")
    model.addConstr(7 * x0 + 9 * x1 <= 47, name="sustainability_score_max")
    model.addConstr(10 * x0 - 10 * x1 >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Packs of paper plates: {x0.varValue}")
        print(f"Packs of napkins: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
