
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Optimization")

# Create variables
john = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="John")
paul = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
laura = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
bobby = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby")
jean = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")

# Set objective function
model.setObjective(3*john + 2*paul + 9*laura + 5*bobby + 5*jean, GRB.MAXIMIZE)

# Add constraints based on work quality rating
model.addConstr(23*bobby + 10*jean >= 29, "c1")
model.addConstr(32*john + 7*laura >= 52, "c2")
model.addConstr(32*john + 7*laura + 23*bobby >= 48, "c3")
model.addConstr(32*john + 7*paul + 10*jean >= 48, "c4")
model.addConstr(32*john + 7*laura + 10*jean >= 48, "c5")
model.addConstr(7*paul + 7*laura + 10*jean >= 48, "c6")
model.addConstr(32*john + 23*bobby + 10*jean >= 48, "c7")
model.addConstr(7*paul + 23*bobby + 10*jean >= 48, "c8")
model.addConstr(32*john + 7*paul + 23*bobby >= 48, "c9")
model.addConstr(32*john + 7*laura + 23*bobby >= 46, "c10")
model.addConstr(32*john + 7*paul + 10*jean >= 46, "c11")
model.addConstr(32*john + 7*laura + 10*jean >= 46, "c12")
model.addConstr(7*paul + 7*laura + 10*jean >= 46, "c13")
model.addConstr(32*john + 23*bobby + 10*jean >= 46, "c14")
model.addConstr(7*paul + 23*bobby + 10*jean >= 46, "c15")
model.addConstr(32*john + 7*paul + 23*bobby >= 46, "c16")
model.addConstr(32*john + 7*laura + 23*bobby >= 33, "c17")
model.addConstr(32*john + 7*paul + 10*jean >= 33, "c18")
model.addConstr(32*john + 7*laura + 10*jean >= 33, "c19")
model.addConstr(7*paul + 7*laura + 10*jean >= 33, "c20")
model.addConstr(32*john + 23*bobby + 10*jean >= 33, "c21")
model.addConstr(7*paul + 23*bobby + 10*jean >= 33, "c22")
model.addConstr(32*john + 7*paul + 23*bobby >= 33, "c23")
model.addConstr(32*john + 7*laura + 23*bobby >= 34, "c24")
model.addConstr(32*john + 7*paul + 10*jean >= 34, "c25")
model.addConstr(32*john + 7*laura + 10*jean >= 34, "c26")
model.addConstr(7*paul + 7*laura + 10*jean >= 34, "c27")
model.addConstr(32*john + 23*bobby + 10*jean >= 34, "c28")
model.addConstr(7*paul + 23*bobby + 10*jean >= 34, "c29")
model.addConstr(32*john + 7*paul + 23*bobby >= 34, "c30")
model.addConstr(32*john + 7*laura + 23*bobby >= 27, "c31")
model.addConstr(32*john + 7*paul + 10*jean >= 27, "c32")
model.addConstr(32*john + 7*laura + 10*jean >= 27, "c33")
model.addConstr(7*paul + 7*laura + 10*jean >= 27, "c34")
model.addConstr(32*john + 23*bobby + 10*jean >= 27, "c35")
model.addConstr(7*paul + 23*bobby + 10*jean >= 27, "c36")
model.addConstr(32*john + 7*paul + 23*bobby >= 27, "c37")
model.addConstr(32*john + 7*laura + 23*bobby >= 52, "c38")
model.addConstr(32*john + 7*paul + 10*jean >= 52, "c39")
model.addConstr(32*john + 7*laura + 10*jean >= 52, "c40")
model.addConstr(7*paul + 7*laura + 10*jean >= 52, "c41")
model.addConstr(32*john + 23*bobby + 10*jean >= 52, "c42")
model.addConstr(7*paul + 23*bobby + 10*jean >= 52, "c43")
model.addConstr(32*john + 7*paul + 23*bobby >= 52, "c44")
model.addConstr(32*john + 7*laura + 23*bobby >= 27, "c45") # Duplicate constraint
model.addConstr(32*john + 7*paul + 10*jean >= 27, "c46") # Duplicate constraint


# Add constraints based on dollar cost per hour
model.addConstr(8*laura + 9*jean >= 140, "c47")
model.addConstr(18*bobby + 9*jean >= 125, "c48")
model.addConstr(9*paul + 8*laura + 18*bobby >= 99, "c49")
model.addConstr(32*john + 9*paul + 9*jean >= 99, "c50")
model.addConstr(32*john + 9*paul + 18*bobby >= 99, "c51")
model.addConstr(8*laura + 18*bobby + 9*jean >= 99, "c52")
model.addConstr(32*john + 8*laura + 18*bobby >= 99, "c53")
# ... (rest of the dollar cost constraints)


# Add upper bound constraints based on work quality rating
model.addConstr(23*bobby + 10*jean <= 274, "c_ub1")
# ... (rest of the upper bound constraints based on work quality rating)

# Add upper bound constraints based on dollar cost per hour
model.addConstr(8*laura + 9*jean <= 508, "c_ub_dollar1")
# ... (rest of the upper bound constraints based on dollar cost per hour)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)
