
import gurobipy as gp

# Create a new model
m = gp.Model("maximize_hours_worked")

# Create variables
bill = m.addVar(type=gp.GRB.INTEGER, name="Bill")
john = m.addVar(type=gp.GRB.INTEGER, name="John")
ringo = m.addVar(type=gp.GRB.INTEGER, name="Ringo")
laura = m.addVar(type=gp.GRB.INTEGER, name="Laura")
mary = m.addVar(type=gp.GRB.INTEGER, name="Mary")
hank = m.addVar(type=gp.GRB.CONTINUOUS, name="Hank")

# Set objective function
m.setObjective(1.72 * bill + 3.31 * john + 5.24 * ringo + 6.21 * laura + 2.25 * mary + 7.84 * hank, gp.GRB.MAXIMIZE)

# Add constraints
likelihood_to_quit = {'Bill': 1.66, 'John': 8.37, 'Ringo': 11.19, 'Laura': 14.76, 'Mary': 9.3, 'Hank': 7.4}

m.addConstr(likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Laura'] * laura >= 9)
m.addConstr(likelihood_to_quit['John'] * john + likelihood_to_quit['Mary'] * mary >= 7)
m.addConstr(likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Mary'] * mary >= 13)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['Hank'] * hank >= 15)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['Mary'] * mary >= 10)
m.addConstr(likelihood_to_quit['John'] * john + likelihood_to_quit['Ringo'] * ringo >= 19)
m.addConstr(likelihood_to_quit['Laura'] * laura + likelihood_to_quit['Hank'] * hank >= 10)
m.addConstr(likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Hank'] * hank >= 12)
m.addConstr(likelihood_to_quit['John'] * john + likelihood_to_quit['Hank'] * hank >= 6)
m.addConstr(likelihood_to_quit['Mary'] * mary + likelihood_to_quit['Hank'] * hank >= 15)

# ... (Add the remaining 3-variable combined constraints similarly)

m.addConstr(likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Hank'] * hank <= 97)
m.addConstr(likelihood_to_quit['John'] * john + likelihood_to_quit['Laura'] * laura <= 121)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['Laura'] * laura <= 80)
m.addConstr(likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Mary'] * mary <= 109)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['Hank'] * hank <= 21)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['Mary'] * mary <= 82)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['John'] * john <= 118)
m.addConstr(likelihood_to_quit['Laura'] * laura + likelihood_to_quit['Mary'] * mary <= 76)
m.addConstr(likelihood_to_quit['Mary'] * mary + likelihood_to_quit['Hank'] * hank <= 93)
m.addConstr(likelihood_to_quit['Bill'] * bill + likelihood_to_quit['John'] * john + likelihood_to_quit['Ringo'] * ringo + likelihood_to_quit['Laura'] * laura + likelihood_to_quit['Mary'] * mary + likelihood_to_quit['Hank'] * hank <= 93)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
