
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
    zinc = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="zinc")
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
    carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
    potassium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="potassium")
    vitamin_b4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b4")

    # Set objective function
    obj = (1 * vitamin_b1**2 + 8 * vitamin_b1 * zinc + 6 * vitamin_b1 * carbohydrates +
           2 * zinc**2 + 4 * zinc * vitamin_b7 + 3 * zinc * carbohydrates +
           3 * vitamin_b7**2 + 3 * vitamin_b7 * carbohydrates + 4 * carbohydrates**2 +
           7 * carbohydrates * potassium + 9 * potassium**2 + 3 * vitamin_b4**2 +
           4 * vitamin_b1 + 8 * vitamin_b7 + 2 * carbohydrates + 3 * potassium)
    m.setObjective(obj, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5 * vitamin_b1 + 1 * zinc + 3 * vitamin_b7 + 5 * carbohydrates + 5 * potassium + 8 * vitamin_b4 <= 62, "r0")
    m.addConstr(3 * vitamin_b7 + 5 * carbohydrates >= 10, "c1")
    m.addConstr(1 * zinc + 5 * carbohydrates >= 5, "c2")
    m.addConstr(3 * vitamin_b7 + 5 * potassium >= 9, "c3")
    m.addConstr(3 * vitamin_b7 + 5 * carbohydrates <= 20, "c4")
    m.addConstr(1 * zinc + 3 * vitamin_b7 <= 17, "c5")
    m.addConstr(5 * carbohydrates + 8 * vitamin_b4 <= 57, "c6")
    m.addConstr(3 * vitamin_b7 + 8 * vitamin_b4 <= 59, "c7")
    m.addConstr(1 * zinc + 8 * vitamin_b4 <= 13, "c8")
    m.addConstr(5 * vitamin_b1 + 5 * potassium <= 57, "c9")
    m.addConstr(5 * vitamin_b1 + 1 * zinc + 5 * potassium <= 15, "c10")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
