
from gurobipy import Model, GRB

# Create a new model
model = Model("fruit_optimization")

# Create variables
bananas = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bananas")
apples = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")

# Set objective function
model.setObjective(6.16 * bananas + 1.89 * apples, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * bananas + 4 * apples >= 28, "min_cost")
model.addConstr(2 * bananas + 1 * apples >= 12, "min_fiber")
model.addConstr(10 * bananas - 4 * apples >= 0, "banana_apple_ratio")
model.addConstr(3 * bananas + 4 * apples <= 41, "max_cost")  # Consolidated cost constraint
model.addConstr(2 * bananas + 1 * apples <= 29, "max_fiber")  # Consolidated fiber constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bananas: {bananas.x}")
    print(f"  Apples: {apples.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

