
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
bananas = m.addVar(vtype=GRB.CONTINUOUS, name="bananas")
apples = m.addVar(vtype=GRB.CONTINUOUS, name="apples")

# Set the objective function
m.setObjective(6.16 * bananas + 1.89 * apples, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * bananas + 4 * apples >= 28, "min_dollar_cost")
m.addConstr(2 * bananas + 1 * apples >= 12, "min_fiber")
m.addConstr(10 * bananas - 4 * apples >= 0, "linear_constraint")
m.addConstr(3 * bananas + 4 * apples <= 41, "max_dollar_cost")
m.addConstr(2 * bananas + 1 * apples <= 29, "max_fiber")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bananas: {bananas.x}")
    print(f"Apples: {apples.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
