
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
bananas = m.addVar(name="bananas", lb=0)  # No lower bound, but can be negative
apples = m.addVar(name="apples", lb=0)  # No lower bound, but can be negative

# Objective function
m.setObjective(6.16 * bananas + 1.89 * apples, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(3 * bananas + 4 * apples >= 28, name="min_spend")
m.addConstr(2 * bananas + apples >= 12, name="min_fiber")
m.addConstr(10 * bananas - 4 * apples >= 0, name="fiber_ratio")
m.addConstr(3 * bananas + 4 * apples <= 65, name="max_spend")
m.addConstr(3 * bananas + 4 * apples <= 41, name="max_spend_41_1")
m.addConstr(2 * bananas + apples <= 37, name="max_fiber")
m.addConstr(2 * bananas + apples <= 29, name="max_fiber_29")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Bananas: {bananas.varValue}")
    print(f"Apples: {apples.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
