
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
monochrome_printers = model.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
postage_stamps = model.addVar(vtype=GRB.INTEGER, name="postage_stamps")

# Set objective function
model.setObjective(4.43 * monochrome_printers + 3.06 * postage_stamps, GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * monochrome_printers + 13 * postage_stamps >= 38, "c1")
model.addConstr(-8 * monochrome_printers + 4 * postage_stamps >= 0, "c2")
model.addConstr(12 * monochrome_printers + 13 * postage_stamps <= 72, "c3")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Monochrome Printers: {monochrome_printers.x}")
    print(f"  Postage Stamps: {postage_stamps.x}")
    print(f"  Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

