
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
monochrome_printers = m.addVar(vtype=GRB.INTEGER, name="monochrome_printers")
postage_stamps = m.addVar(vtype=GRB.INTEGER, name="postage_stamps")

# Set the objective function
m.setObjective(4.43 * monochrome_printers + 3.06 * postage_stamps, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * monochrome_printers + 13 * postage_stamps >= 38, name="usefulness_rating_min")
m.addConstr(-8 * monochrome_printers + 4 * postage_stamps >= 0, name="combination_constraint")
m.addConstr(12 * monochrome_printers + 13 * postage_stamps <= 72, name="usefulness_rating_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Monochrome printers: {monochrome_printers.x}")
    print(f"Postage stamps: {postage_stamps.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
