
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(name="monochrome_printers", vtype=gurobi.GRB.INTEGER)
    P = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 4.43M + 3.06P
    model.setObjective(4.43 * M + 3.06 * P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12 * M + 13 * P >= 38, name="usefulness_rating_min")
    model.addConstr(-8 * M + 4 * P >= 0, name="monochrome_postage_balance")
    model.addConstr(12 * M + 13 * P <= 72, name="usefulness_rating_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Monochrome Printers: {M.varValue}")
        print(f"Postage Stamps: {P.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
