
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize_Work_Hours_Cost")

# Create variables
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Peggy_Hours")
laura_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Laura_Hours")
ringo_hours = model.addVar(vtype=GRB.CONTINUOUS, name="Ringo_Hours")


# Set objective function
model.setObjective(9.55 * peggy_hours + 4.63 * laura_hours + 1.21 * ringo_hours, GRB.MINIMIZE)

# Add constraints

# Resource Constraints (implicit in problem description, not explicitly stated as constraints)
# These are already handled by the coefficients in the other constraints.

# Organization Score Constraints
model.addConstr(8 * laura_hours + 6 * ringo_hours >= 26, "Organization_Score_Laura_Ringo")
model.addConstr(2 * peggy_hours + 8 * laura_hours >= 18, "Organization_Score_Peggy_Laura")
model.addConstr(2 * peggy_hours + 8 * laura_hours + 6 * ringo_hours >= 18, "Organization_Score_Total")
model.addConstr(8 * laura_hours + 6 * ringo_hours <= 86, "Organization_Score_Laura_Ringo_Max")
model.addConstr(2 * peggy_hours + 6 * ringo_hours <= 80, "Organization_Score_Peggy_Ringo_Max")


# Work Quality Rating Constraints
model.addConstr(8 * laura_hours + 7 * ringo_hours >= 10, "Work_Quality_Laura_Ringo")
model.addConstr(6 * peggy_hours + 8 * laura_hours + 7 * ringo_hours >= 12, "Work_Quality_Total_1")
model.addConstr(6 * peggy_hours + 8 * laura_hours + 7 * ringo_hours >= 12, "Work_Quality_Total_2") # Redundant constraint
model.addConstr(6 * peggy_hours + 7 * ringo_hours <= 30, "Work_Quality_Peggy_Ringo_Max")


# Dollar Cost per Hour Constraints
model.addConstr(6 * peggy_hours + 10 * laura_hours >= 22, "Dollar_Cost_Peggy_Laura")
model.addConstr(10 * laura_hours + 1 * ringo_hours >= 20, "Dollar_Cost_Laura_Ringo")
model.addConstr(6 * peggy_hours + 10 * laura_hours + 1 * ringo_hours >= 20, "Dollar_Cost_Total")
model.addConstr(6 * peggy_hours + 10 * laura_hours <= 78, "Dollar_Cost_Peggy_Laura_Max")
model.addConstr(6 * peggy_hours + 1 * ringo_hours <= 95, "Dollar_Cost_Peggy_Ringo_Max")


# Additional Constraint
model.addConstr(-3 * peggy_hours + 9 * laura_hours >= 0, "Additional_Constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('\nCost: %g' % model.objVal)
    print('\nSolution:')
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible or unbounded")

