
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_Peggy', lb=0, ub=GRB.INFINITY)
x1 = m.addVar(name='hours_worked_by_Laura', lb=0, ub=GRB.INFINITY)
x2 = m.addVar(name='hours_worked_by_Ringo', lb=0, ub=GRB.INFINITY)

# Objective function
m.setObjective(9.55*x0 + 4.63*x1 + 1.21*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(8*x1 + 6*x2 >= 26, name='organization_score_Laura_Ringo_min')
m.addConstr(2*x0 + 8*x1 >= 18, name='organization_score_Peggy_Laura_min')
m.addConstr(2*x0 + 8*x1 + 6*x2 >= 18, name='organization_score_all_min')
m.addConstr(8*x1 + 6*x2 <= 86, name='organization_score_Laura_Ringo_max')
m.addConstr(2*x0 + 6*x2 <= 80, name='organization_score_Peggy_Ringo_max')

m.addConstr(8*x1 + 7*x2 >= 10, name='work_quality_Laura_Ringo_min')
m.addConstr(6*x0 + 8*x1 + 7*x2 >= 12, name='work_quality_all_min')
m.addConstr(6*x0 + 7*x2 <= 30, name='work_quality_Peggy_Ringo_max')

m.addConstr(6*x0 + 10*x1 >= 22, name='dollar_cost_Peggy_Laura_min')
m.addConstr(10*x1 + x2 >= 20, name='dollar_cost_Laura_Ringo_min')
m.addConstr(6*x0 + 10*x1 + x2 >= 20, name='dollar_cost_all_min')
m.addConstr(6*x0 + 10*x1 <= 78, name='dollar_cost_Peggy_Laura_max')
m.addConstr(6*x0 + x2 <= 95, name='dollar_cost_Peggy_Ringo_max')

m.addConstr(-3*x0 + 9*x1 >= 0, name='additional_constraint')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {x0.x}")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Ringo: {x2.x}")
else:
    print("No optimal solution found")
